﻿#include "stdafx.h"
#include "printer_base.h"

#ifdef STATIC_DLL
#pragma comment(lib, "ZPL_SDK.lib")

#include "sdk_common_api.h"
#include "zpl_sdk_api.h"
#endif

/*
 * ///////////////////////////////////
 * define
 * //////////////////////////////////
 */
pPrinterCreator								fPrinterCreator;
pPrinterCreatorS							fPrinterCreatorS;
pPrinterDestroy								fPrinterDestroy;
pPortOpen									fPortOpen;
pPortClose									fPortClose;
pWriteData									fWriteData;
pReadData									fReadData;
pDirectIO									fDirectIO;
pGetUriOption								fGetUriOption;
pZPL_GetPrinterDpi							fGetPrinterDpi;
pZPL_StartFormat							fStartFormat;
pZPL_GetPrinterStatus						fGetPrinterStatus;
pZPL_EndFormat								fEndFormat;
pZPL_SetChangeFontEncoding					fSetChangeFontEncoding;
pZPL_SetVietMode							fSetVietMode;
pZPL_SetVietFontEncoding					fSetVietFontEncoding;
pZPL_SetUserFontName						fPrintSetUserFontName;
pZPL_Text									fPrintText;
pZPL_Text_Block								fPrintTextBlock;
pZPL_BarCode39								fBarCode39;
pZPL_Pdf417									fPdf417;
pZPL_MicroPdf417							fMicroPdf417;
pZPL_SetLabelHome							fSetLabelHome;
pZPL_SetLabelLength							fSetLabelLength;
pZPL_SetTearOffAdjustPosition				fSetTearOffAdjustPosition;
pZPL_CodeEan8								fCodeEan8;
pZPL_QRCode									fQRCode;
pZPL_UpcExtensions							fUpcExtensions;
pZPL_UpcaBarcode							fUpcaBarcode;
pZPL_GraphicBox								fGraphicBox;
pZPL_GraphicCircle							fGraphicCircle;
pZPL_GraphicDiagonalLine					fGraphicDiagonaline;
pZPL_GraphicEllipse							fGraphicEllipse;
pZPL_GraphicSymbol							fGraphicSymbol;
pZPL_PrintImage								fPrintImage;
pZPL_PrintImageStream						fPrintImageStream;
pZPL_SetDiagnosticsMode						fSetDiagnosticsMode;
pZPL_SetPrintRate							fSetPrintRate;
pZPL_SetPrintDarkness						fSetPrintDarkness;
pZPL_PrintConfigurationLabel				fPrintConfigurationLabel;
pZPL_SetSerialCommunications				fSetSerialCommunications;

pZPL_RfidWrite			fZPL_RfidWrite;
pZPL_RfidRead			fZPL_RfidRead;
pZPL_RfidCalibration	fZPL_RfidCalibration;
GetUsbList              DemGetUsbList;
pDownloadFontFile		fDownloadFontFile;
downloadYModem			DemdownloadYModem;
pDownloadFMWImg         fDownloadFMWImg;

void	* hprinter;
HMODULE m_hDll;

void UnloadDll()
{
#ifndef STATIC_DLL
	FreeLibrary( m_hDll );
#endif
}


BOOL LoadDll()
{
#ifndef STATIC_DLL
	m_hDll = LoadLibrary(_T("ZPL_SDK.dll"));
	if (m_hDll == 0)
		return(FALSE);

	fPrinterCreator			= (pPrinterCreator) GetProcAddress( m_hDll, "PrinterCreator" );
	fPrinterCreatorS			= (pPrinterCreatorS) GetProcAddress( m_hDll, "PrinterCreatorS" );
	fPrinterDestroy          = (pPrinterDestroy)GetProcAddress(m_hDll, "PrinterDestroy");
	fPortOpen                = (pPortOpen)GetProcAddress(m_hDll, "PortOpen");
	fPortClose				= (pPortClose) GetProcAddress( m_hDll, "PortClose" );
	fWriteData				= (pWriteData)GetProcAddress(m_hDll, "WriteData");
	fReadData				= (pReadData)GetProcAddress(m_hDll, "ReadData");
	fDirectIO				= (pDirectIO) GetProcAddress( m_hDll, "DirectIO" );
	fGetUriOption			= (pGetUriOption) GetProcAddress( m_hDll, "GetUriOption" );
	fGetPrinterDpi			= (pZPL_GetPrinterDpi) GetProcAddress( m_hDll, "ZPL_GetPrinterDpi" );
	fStartFormat				= (pZPL_StartFormat) GetProcAddress( m_hDll, "ZPL_StartFormat" );
	fGetPrinterStatus		= (pZPL_GetPrinterStatus) GetProcAddress( m_hDll, "ZPL_GetPrinterStatus" );
	fEndFormat				= (pZPL_EndFormat) GetProcAddress( m_hDll, "ZPL_EndFormat" );
	fSetChangeFontEncoding   = (pZPL_SetChangeFontEncoding)GetProcAddress(m_hDll, "ZPL_SetChangeFontEncoding");
	fSetVietMode				= (pZPL_SetVietMode)GetProcAddress(m_hDll, "ZPL_SetVietMode");
	fSetVietFontEncoding		= (pZPL_SetVietFontEncoding)GetProcAddress(m_hDll, "ZPL_SetVietFontEncoding");
	fPrintSetUserFontName	= (pZPL_SetUserFontName) GetProcAddress( m_hDll, "ZPL_SetUserFontName" );
	fPrintText				= (pZPL_Text) GetProcAddress( m_hDll, "ZPL_Text" );
	//fPrintTextBlock			= (pZPL_Text_Block) GetProcAddress( m_hDll, "ZPL_Text_Block" );
	fBarCode39				= (pZPL_BarCode39) GetProcAddress( m_hDll, "ZPL_BarCode39" );
	fPdf417					= (pZPL_Pdf417) GetProcAddress( m_hDll, "ZPL_Pdf417" );
	fMicroPdf417				= (pZPL_MicroPdf417) GetProcAddress( m_hDll, "ZPL_MicroPdf417" );
	fSetLabelHome			= (pZPL_SetLabelHome) GetProcAddress( m_hDll, "ZPL_SetLabelHome" );
	fSetLabelLength			= (pZPL_SetLabelLength) GetProcAddress( m_hDll, "ZPL_SetLabelLength" );
	fSetTearOffAdjustPosition= (pZPL_SetTearOffAdjustPosition) GetProcAddress( m_hDll, "ZPL_SetTearOffAdjustPosition" );
	fCodeEan8				= (pZPL_CodeEan8) GetProcAddress( m_hDll, "ZPL_CodeEan8" );
	fQRCode				    = (pZPL_QRCode) GetProcAddress( m_hDll, "ZPL_QRCode" );
	fUpcExtensions			= (pZPL_UpcExtensions) GetProcAddress( m_hDll, "ZPL_UpcExtensions" );
	fUpcaBarcode			    = (pZPL_UpcaBarcode) GetProcAddress( m_hDll, "ZPL_UpcaBarcode" );
	fGraphicBox			    = (pZPL_GraphicBox) GetProcAddress( m_hDll, "ZPL_GraphicBox" );
	fGraphicCircle			= (pZPL_GraphicCircle) GetProcAddress( m_hDll, "ZPL_GraphicCircle" );
	fGraphicDiagonaline		= (pZPL_GraphicDiagonalLine) GetProcAddress( m_hDll, "ZPL_GraphicDiagonalLine" );
	fGraphicEllipse			= (pZPL_GraphicEllipse) GetProcAddress( m_hDll, "ZPL_GraphicEllipse" );
	fGraphicSymbol			= (pZPL_GraphicSymbol) GetProcAddress( m_hDll, "ZPL_GraphicSymbol" );
	fPrintImage              = (pZPL_PrintImage)GetProcAddress( m_hDll, "ZPL_PrintImage");
	fSetDiagnosticsMode		= (pZPL_SetDiagnosticsMode) GetProcAddress( m_hDll, "ZPL_SetDiagnosticsMode" );
	fSetPrintRate			= (pZPL_SetPrintRate) GetProcAddress( m_hDll, "ZPL_SetPrintRate" );
	fSetPrintDarkness		= (pZPL_SetPrintDarkness) GetProcAddress( m_hDll, "ZPL_SetPrintDarkness" );
	fPrintConfigurationLabel	= (pZPL_PrintConfigurationLabel) GetProcAddress( m_hDll, "ZPL_PrintConfigurationLabel" );
	fSetSerialCommunications	= (pZPL_SetSerialCommunications) GetProcAddress( m_hDll, "ZPL_SetSerialCommunications" );
	DemGetUsbList               = (GetUsbList)GetProcAddress(m_hDll, "GetUsbList");
	fDownloadFontFile = (pDownloadFontFile)GetProcAddress(m_hDll, "DownloadFontFile");
	//DemdownloadYModem           = (downloadYModem)GetProcAddress(m_hDll, "downloadYModem");
	fDownloadFMWImg = (pDownloadFMWImg)GetProcAddress(m_hDll, "DownloadFMWImg");
#else
	fPrinterCreator				= ::PrinterCreator		;
	fPrinterCreatorS			= PrinterCreatorS		;
	fPrinterDestroy				= PrinterDestroy		;
	fPortOpen					= PortOpen				;
	fPortClose					= PortClose				;
	fWriteData					= WriteData				;
	fReadData					= ReadData				;
	fDirectIO					= DirectIO				;
	fGetUriOption				= GetUriOption			;
	fGetPrinterDpi				= ZPL_GetPrinterDpi;
	fStartFormat				= ZPL_StartFormat;
	fGetPrinterStatus			= ZPL_GetPrinterStatus;
	fEndFormat					= ZPL_EndFormat;
	fSetChangeFontEncoding		= ZPL_SetChangeFontEncoding;
	//fSetVietMode				= ZPL_SetVietMode;
	//fSetVietFontEncoding		= ZPL_SetVietFontEncoding;
	//fPrintSetUserFontName		= ZPL_SetUserFontName;
	fPrintText					= ZPL_Text;
	//fPrintTextBlock				= ZPL_Text_Block;
	fBarCode39					= ZPL_BarCode39;
	fPdf417						= ZPL_Pdf417;
	fMicroPdf417				= ZPL_MicroPdf417;
	fSetLabelHome				= ZPL_SetLabelHome;
	fSetLabelLength				= ZPL_SetLabelLength;
	fSetTearOffAdjustPosition	= ZPL_SetTearOffAdjustPosition;
	fCodeEan8					= ZPL_CodeEan8;
	fQRCode						= ZPL_QRCode;
	fUpcExtensions				= ZPL_UpcExtensions;
	fUpcaBarcode			    = ZPL_UpcaBarcode;
	fGraphicBox					= ZPL_GraphicBox;
	fGraphicCircle				= ZPL_GraphicCircle;
	fGraphicDiagonaline			= ZPL_GraphicDiagonalLine;
	fGraphicEllipse				= ZPL_GraphicEllipse;
	fGraphicSymbol				= ZPL_GraphicSymbol;
	fPrintImage					= ZPL_PrintImage;
	fPrintImageStream			= ZPL_PrintImageStream;
	fSetDiagnosticsMode			= ZPL_SetDiagnosticsMode;
	fSetPrintRate				= ZPL_SetPrintRate;
	fSetPrintDarkness			= ZPL_SetPrintDarkness;
	fPrintConfigurationLabel	= ZPL_PrintConfigurationLabel;
	fSetSerialCommunications	= ZPL_SetSerialCommunications;

	fZPL_RfidWrite				= ZPL_RfidWrite;
	fZPL_RfidRead				= ZPL_RfidRead;
	fZPL_RfidCalibration		= ZPL_RfidCalibration;
#endif
	

	return(TRUE);
}
